# Autor: René Albarus - https://www.tech-faq.net
#
# Beschreibung: 
# Auslesen nicht mehr aktiver Computerkonten im Active Directory, welche nicht deaktiviert wurden
# Auf diese Weise lassen sich verwaiste Computerkonten finden
# Der Wert TimeSpan kann angepasst werden (100.00:00:00 =  100 Tage

Search-ADAccount -AccountInactive -ComputersOnly -TimeSpan 100.00:00:00 | 
Where {$_.Enabled -eq "True"} | 
sort -property LastLogonDate -desc | 
ft Name, LastLogonDate, Enabled -autosize