# Author  : René Albarus
# Date    : 07.04.2021
# Website : https://www.tech-faq.net

# Kopieren sämtlicher auf dem Computer gespeicherten Sperrbildschirm Hintergründe in einem Ordner auf dem Benutzerdesktop
# Der Ablageort kann in der Variable $ablage geändert werden.
$ablage = "$env:USERPROFILE\Desktop\Wallpapers\"
$temp = "$env:USERPROFILE\Desktop\Wallpapers\Temp"

# Erstelle Zielordner und Tempordner, falls nicht vorhanden
 if (!(Test-Path $ablage)) {New-Item -Path $ablage -ItemType Directory}
 if (!(Test-Path $temp)) {New-Item -Path $temp -ItemType Directory}

# Speicherort der Bilddateien in Variable speichern
 $item = "$env:localappdata\Packages\Microsoft.Windows.ContentDeliveryManager_cw5n1h2txyewy\LocalState\Assets"

# Kopieren der Bilddateien in den Tempodner
 Get-ChildItem -path $item | Where-Object { $_.length -gt 204800 } | copy-item -destination $temp

# Umbenennen der Dateien in JPG-Dateien
Get-ChildItem $temp | rename-item -newname { [io.path]::ChangeExtension($_.name, "jpg") } 
Get-ChildItem $temp | move-item -Destination $ablage -Force

#Tempordner löschen
Remove-Item $temp -Force